/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resources;

import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.archive.compression.Bzip2Archiver;
import org.gradle.api.internal.file.archive.compression.GzipArchiver;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.internal.resources.ApiTextResourceAdapter;
import org.gradle.api.internal.resources.DefaultResourceResolver;
import org.gradle.api.internal.resources.DefaultTextResourceFactory;
import org.gradle.api.internal.resources.ResourceResolver;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.resources.ResourceHandler;
import org.gradle.api.resources.TextResourceFactory;
import org.gradle.api.resources.internal.ReadableResourceInternal;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;

public class DefaultResourceHandler
implements ResourceHandler {
    private final ResourceResolver resourceResolver;
    private final TextResourceFactory textResourceFactory;

    private DefaultResourceHandler(ResourceResolver resourceResolver, TextResourceFactory textResourceFactory) {
        this.resourceResolver = resourceResolver;
        this.textResourceFactory = textResourceFactory;
    }

    public ReadableResourceInternal gzip(Object path) {
        return new GzipArchiver(this.resourceResolver.resolveResource(path));
    }

    public ReadableResourceInternal bzip2(Object path) {
        return new Bzip2Archiver(this.resourceResolver.resolveResource(path));
    }

    public TextResourceFactory getText() {
        return this.textResourceFactory;
    }

    public static interface Factory {
        public ResourceHandler create(FileOperations var1);

        public static Factory from(FileResolver fileResolver, TaskDependencyFactory taskDependencyFactory, FileSystem fileSystem, TemporaryFileProvider tempFileProvider, ApiTextResourceAdapter.Factory textResourceAdapterFactory) {
            return new FactoryImpl(fileResolver, taskDependencyFactory, fileSystem, tempFileProvider, textResourceAdapterFactory);
        }

        public static class FactoryImpl
        implements Factory {
            private final FileResolver fileResolver;
            private final FileSystem fileSystem;
            private final TemporaryFileProvider tempFileProvider;
            private final TaskDependencyFactory taskDependencyFactory;
            private final ApiTextResourceAdapter.Factory textResourceAdapterFactory;

            public FactoryImpl(FileResolver fileResolver, TaskDependencyFactory taskDependencyFactory, FileSystem fileSystem, TemporaryFileProvider tempFileProvider, ApiTextResourceAdapter.Factory textResourceAdapterFactory) {
                this.fileResolver = fileResolver;
                this.taskDependencyFactory = taskDependencyFactory;
                this.fileSystem = fileSystem;
                this.tempFileProvider = tempFileProvider;
                this.textResourceAdapterFactory = textResourceAdapterFactory;
            }

            @Override
            public DefaultResourceHandler create(FileOperations fileOperations) {
                DefaultResourceResolver resourceResolver = new DefaultResourceResolver(this.fileResolver, this.fileSystem);
                DefaultTextResourceFactory textResourceFactory = new DefaultTextResourceFactory(fileOperations, this.tempFileProvider, this.textResourceAdapterFactory, this.taskDependencyFactory);
                return new DefaultResourceHandler(resourceResolver, textResourceFactory);
            }
        }
    }
}

