/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.jox;

import com.wutka.dtd.DTD;
import com.wutka.jox.JOXBeanOutput;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JOXBeanDOM
extends JOXBeanOutput {
    protected Document document;
    protected static Hashtable beanCache = new Hashtable();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;

    public JOXBeanDOM() throws IOException {
        this(true);
    }

    public JOXBeanDOM(Document document) throws IOException {
        this(document, true);
    }

    public JOXBeanDOM(String string) throws IOException {
        this.dtd = this.readDTD(string);
        this.setupNameTranslation();
        this.createDocument();
        this.writeAttributes = false;
    }

    public JOXBeanDOM(DTD dTD) throws IOException {
        this.dtd = dTD;
        this.setupNameTranslation();
        this.createDocument();
        this.writeAttributes = false;
    }

    public JOXBeanDOM(Document document, String string) throws IOException {
        this.document = document;
        this.dtd = this.readDTD(string);
        this.setupNameTranslation();
        this.writeAttributes = false;
    }

    public JOXBeanDOM(Document document, DTD dTD) {
        this.dtd = dTD;
        this.setupNameTranslation();
        this.writeAttributes = false;
    }

    public JOXBeanDOM(boolean bl) throws IOException {
        this.writeAttributes = bl;
        this.nameTranslation = null;
        this.createDocument();
    }

    public JOXBeanDOM(Document document, boolean bl) throws IOException {
        this.document = document;
        this.writeAttributes = bl;
        this.nameTranslation = null;
    }

    protected void createDocument() throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.toString());
        }
    }

    public Document beanToDocument(String string, Object object) throws IOException {
        this.document.appendChild(this.storeObject(string, object));
        return this.document;
    }

    public Element storeObject(String string, Object object) throws IOException {
        String string2 = this.getTranslatedEntityName(string);
        if (string2 == null) {
            return null;
        }
        Element element = this.document.createElement(string2);
        if (this.writeAttributes) {
            this.storeObjectFields(string2, object, 1, element);
        }
        this.storeObjectFields(string2, object, 2, element);
        return element;
    }

    public void storeObjectFields(String string, Object object, int n, Element element) throws IOException {
        if (object == null) {
            return;
        }
        try {
            BeanInfo beanInfo = (BeanInfo)beanCache.get(object.getClass());
            if (beanInfo == null) {
                beanInfo = Introspector.getBeanInfo(object.getClass(), class$java$lang$Object == null ? (class$java$lang$Object = JOXBeanDOM.class$("java.lang.Object")) : class$java$lang$Object);
                beanCache.put(object.getClass(), beanInfo);
            }
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n2 = 0;
            while (n2 < propertyDescriptorArray.length) {
                if (propertyDescriptorArray[n2] instanceof IndexedPropertyDescriptor) {
                    if (n == 2) {
                        this.storeIndexedProperty(string, object, (IndexedPropertyDescriptor)propertyDescriptorArray[n2], element);
                    }
                } else {
                    this.storeProperty(string, object, propertyDescriptorArray[n2], n, element);
                }
                ++n2;
            }
        }
        catch (IntrospectionException introspectionException) {
            throw new IOException("Got introspection exception " + introspectionException.toString());
        }
    }

    public void storeProperty(String string, Object object, PropertyDescriptor propertyDescriptor, int n, Element element) throws IOException {
        try {
            Method method = propertyDescriptor.getReadMethod();
            Object object2 = method.invoke(object, JOXBeanOutput.getParams);
            this.storePropertyValue(string, object2, propertyDescriptor, n, element);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException("Unable to read property " + propertyDescriptor.getName() + ": " + invocationTargetException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Unable to read property " + propertyDescriptor.getName() + ": " + illegalAccessException.toString());
        }
    }

    public void storeIndexedProperty(String string, Object object, IndexedPropertyDescriptor indexedPropertyDescriptor, Element element) throws IOException {
        try {
            Method method = indexedPropertyDescriptor.getReadMethod();
            Object[] objectArray = (Object[])method.invoke(object, JOXBeanOutput.getParams);
            int n = 0;
            while (n < objectArray.length) {
                this.storePropertyValue(string, objectArray[n], indexedPropertyDescriptor, 3, element);
                ++n;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException("Unable to read property " + indexedPropertyDescriptor.getName() + ": " + invocationTargetException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Unable to read property " + indexedPropertyDescriptor.getName() + ": " + illegalAccessException.toString());
        }
    }

    public void storePropertyValue(String string, Object object, PropertyDescriptor propertyDescriptor, int n, Element element) throws IOException {
        Class<?> clazz = propertyDescriptor.getPropertyType();
        if (clazz.isArray() && object != null) {
            clazz = clazz.getComponentType();
            int n2 = Array.getLength(object);
            int n3 = 0;
            while (n3 < n2) {
                Object object2 = Array.get(object, n3);
                this.storePropertyValueByType(string, object2, propertyDescriptor, n, element, clazz);
                ++n3;
            }
        } else {
            this.storePropertyValueByType(string, object, propertyDescriptor, n, element, clazz);
        }
    }

    public void storePropertyValueByType(String string, Object object, PropertyDescriptor propertyDescriptor, int n, Element element, Class clazz) throws IOException {
        Element element2;
        if (clazz.equals(Integer.TYPE) || clazz.equals(Long.TYPE) || clazz.equals(Short.TYPE) || clazz.equals(Byte.TYPE) || clazz.equals(Boolean.TYPE) || clazz.equals(Float.TYPE) || clazz.equals(Double.TYPE) || (class$java$lang$Integer == null ? (class$java$lang$Integer = JOXBeanDOM.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(clazz) || (class$java$lang$Long == null ? (class$java$lang$Long = JOXBeanDOM.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(clazz) || (class$java$lang$Short == null ? (class$java$lang$Short = JOXBeanDOM.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(clazz) || (class$java$lang$Byte == null ? (class$java$lang$Byte = JOXBeanDOM.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(clazz) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JOXBeanDOM.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz) || (class$java$lang$Float == null ? (class$java$lang$Float = JOXBeanDOM.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(clazz) || (class$java$lang$Double == null ? (class$java$lang$Double = JOXBeanDOM.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(clazz)) {
            if (object != null) {
                this.storeBasicType(string, propertyDescriptor.getName(), object, n, element);
            }
        } else if ((class$java$lang$String == null ? (class$java$lang$String = JOXBeanDOM.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz)) {
            if (object != null) {
                this.storeString(string, propertyDescriptor.getName(), object, n, element);
            }
        } else if ((class$java$util$Date == null ? (class$java$util$Date = JOXBeanDOM.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(clazz)) {
            if (object != null) {
                this.storeDate(string, propertyDescriptor.getName(), object, n, element);
            }
        } else if ((n == 2 || n == 3) && object != null && (element2 = this.storeObject(propertyDescriptor.getName(), object)) != null) {
            element.appendChild(element2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void storeBasicType(String string, String string2, Object object, int n, Element element) throws IOException {
        String string3 = this.getTranslatedChildName(string, string2);
        if (string3 == null) {
            return;
        }
        if ((this.writeAttributes || this.writeAsAttribute(string, string3)) && n != 3) {
            if (n != 1) return;
            element.setAttribute(string3, object.toString());
            return;
        } else {
            Element element2 = this.document.createElement(string3);
            element2.appendChild(this.document.createTextNode(object.toString()));
            element.appendChild(element2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void storeString(String string, String string2, Object object, int n, Element element) throws IOException {
        String string3 = this.getTranslatedChildName(string, string2);
        if (string3 == null) {
            return;
        }
        if ((this.writeAttributes || this.writeAsAttribute(string, string3)) && n != 3) {
            if (n != 1) return;
            element.setAttribute(string3, (String)object);
            return;
        } else {
            Element element2 = this.document.createElement(string3);
            element2.appendChild(this.document.createTextNode((String)object));
            element.appendChild(element2);
        }
    }

    public void storeDate(String string, String string2, Object object, int n, Element element) throws IOException {
        String string3 = this.getTranslatedChildName(string, string2);
        if (string3 == null) {
            return;
        }
        if ((this.writeAttributes || this.writeAsAttribute(string, string3)) && n != 3) {
            if (n == 1) {
                element.setAttribute(string3, this.dateFormat.format((Date)object));
            }
        } else {
            Element element2 = this.document.createElement(string3);
            element2.appendChild(this.document.createTextNode(this.dateFormat.format((Date)object)));
            element.appendChild(element2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

