/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.junit.result.TestFailure;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.internal.tasks.testing.report.ClassTestResults;
import org.gradle.api.internal.tasks.testing.report.PageRenderer;
import org.gradle.api.internal.tasks.testing.report.TestResult;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.html.SimpleHtmlWriter;
import org.gradle.internal.xml.SimpleMarkupWriter;
import org.gradle.reporting.CodePanelRenderer;
import org.gradle.util.GUtil;

class ClassPageRenderer
extends PageRenderer<ClassTestResults> {
    private final CodePanelRenderer codePanelRenderer = new CodePanelRenderer();
    private final TestResultsProvider resultsProvider;

    public ClassPageRenderer(TestResultsProvider provider) {
        this.resultsProvider = provider;
    }

    @Override
    protected void renderBreadcrumbs(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("div").attribute("class", "breadcrumbs").startElement("a").attribute("href", ((ClassTestResults)this.getResults()).getUrlTo(((ClassTestResults)this.getResults()).getParent().getParent())).characters((CharSequence)"all").endElement().characters((CharSequence)" > ").startElement("a").attribute("href", ((ClassTestResults)this.getResults()).getUrlTo(((ClassTestResults)this.getResults()).getPackageResults())).characters((CharSequence)((ClassTestResults)this.getResults()).getPackageResults().getName()).endElement().characters((CharSequence)(" > " + ((ClassTestResults)this.getResults()).getSimpleName())).endElement();
    }

    private void renderTests(SimpleHtmlWriter htmlWriter) throws IOException {
        SimpleMarkupWriter writer = htmlWriter.startElement("table");
        this.renderTableHead(writer, this.determineTableHeaders());
        for (TestResult test : ((ClassTestResults)this.getResults()).getTestResults()) {
            this.renderTableRow(writer, test);
        }
        htmlWriter.endElement();
    }

    private List<String> determineTableRow(TestResult test) {
        return this.methodNameColumnExists() ? Arrays.asList(test.getDisplayName(), test.getName(), test.getFormattedDuration(), test.getFormattedResultType()) : Arrays.asList(test.getDisplayName(), test.getFormattedDuration(), test.getFormattedResultType());
    }

    private List<String> determineTableHeaders() {
        return this.methodNameColumnExists() ? Arrays.asList("Test", "Method name", "Duration", "Result") : Arrays.asList("Test", "Duration", "Result");
    }

    private void renderTableHead(SimpleMarkupWriter writer, List<String> headers) throws IOException {
        writer.startElement("thead").startElement("tr");
        for (String header : headers) {
            writer.startElement("th").characters((CharSequence)header).endElement();
        }
        writer.endElement().endElement();
    }

    private void renderTableRow(SimpleMarkupWriter writer, TestResult test) throws IOException {
        writer.startElement("tr");
        for (String cell : this.determineTableRow(test)) {
            writer.startElement("td").attribute("class", test.getStatusClass()).characters((CharSequence)cell).endElement();
        }
        writer.endElement();
    }

    private boolean methodNameColumnExists() {
        for (TestResult result : ((ClassTestResults)this.getResults()).getTestResults()) {
            if (result.getName().equals(result.getDisplayName())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void renderFailures(SimpleHtmlWriter htmlWriter) throws IOException {
        for (TestResult test : ((ClassTestResults)this.getResults()).getFailures()) {
            htmlWriter.startElement("div").attribute("class", "test").startElement("a").attribute("name", test.getId().toString()).characters((CharSequence)"").endElement().startElement("h3").attribute("class", test.getStatusClass()).characters((CharSequence)test.getDisplayName()).endElement();
            for (TestFailure failure : test.getFailures()) {
                String message = GUtil.isTrue((Object)failure.getMessage()) && !failure.getStackTrace().contains(failure.getMessage()) ? failure.getMessage() + SystemProperties.getInstance().getLineSeparator() + SystemProperties.getInstance().getLineSeparator() + failure.getStackTrace() : failure.getStackTrace();
                this.codePanelRenderer.render(message, htmlWriter);
            }
            htmlWriter.endElement();
        }
    }

    @Override
    protected void registerTabs() {
        this.addFailuresTab();
        this.addTab("Tests", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

            public void doExecute(SimpleHtmlWriter writer) throws IOException {
                ClassPageRenderer.this.renderTests(writer);
            }
        });
        final long classId = ((ClassTestResults)this.getModel()).getId();
        if (this.resultsProvider.hasOutput(classId, TestOutputEvent.Destination.StdOut)) {
            this.addTab("Standard output", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

                protected void doExecute(SimpleHtmlWriter htmlWriter) throws IOException {
                    htmlWriter.startElement("span").attribute("class", "code").startElement("pre").characters((CharSequence)"");
                    ClassPageRenderer.this.resultsProvider.writeAllOutput(classId, TestOutputEvent.Destination.StdOut, (Writer)htmlWriter);
                    htmlWriter.endElement().endElement();
                }
            });
        }
        if (this.resultsProvider.hasOutput(classId, TestOutputEvent.Destination.StdErr)) {
            this.addTab("Standard error", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

                protected void doExecute(SimpleHtmlWriter element) throws Exception {
                    element.startElement("span").attribute("class", "code").startElement("pre").characters((CharSequence)"");
                    ClassPageRenderer.this.resultsProvider.writeAllOutput(classId, TestOutputEvent.Destination.StdErr, (Writer)element);
                    element.endElement().endElement();
                }
            });
        }
    }
}

