/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.plugins;

import java.util.concurrent.Callable;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.language.plugins.NativeBasePlugin;
import org.gradle.nativeplatform.test.TestComponent;
import org.gradle.nativeplatform.test.TestSuiteComponent;
import org.gradle.testing.base.plugins.TestingBasePlugin;

@Incubating
public class NativeTestingBasePlugin
implements Plugin<ProjectInternal> {
    public void apply(final ProjectInternal project) {
        project.getPluginManager().apply(LifecycleBasePlugin.class);
        project.getPluginManager().apply(NativeBasePlugin.class);
        project.getPluginManager().apply(TestingBasePlugin.class);
        TaskContainerInternal tasks = project.getTasks();
        Task test = tasks.create("test");
        test.dependsOn(new Object[]{new Callable<Object>(){

            @Override
            public Object call() {
                TestSuiteComponent unitTestSuite = (TestSuiteComponent)project.getComponents().withType(TestSuiteComponent.class).findByName("test");
                if (unitTestSuite != null && unitTestSuite.getTestBinary().isPresent()) {
                    return ((TestComponent)unitTestSuite.getTestBinary().get()).getRunTask().get();
                }
                return null;
            }
        }});
        tasks.getByName("check").dependsOn(new Object[]{test});
    }
}

